import os
import sys
import shutil


dataset = sys.argv[1]

filenames = []
for filename in os.listdir("."):
    terms = filename.split(".")
    if len(terms) != 4:
        continue
    if terms[0] != dataset:
        continue
    if terms[2] != "ctss":
        continue
    if terms[3] != "bed":
        continue
    try:
        number = int(terms[1])
    except ValueError:
        continue
    filenames.append([number, filename])

for number, filename in sorted(filenames):
    print("Writing pathlist")
    stream = open("pathlist", "w")
    stream.write(filename + "\n")
    stream.close()
    command = "Enhancers/scripts/bidir_enhancers -f pathlist -m Enhancers/mask/hg38_neg_filter_500_merged.bed -o enhancer_predictions.%d" % number
    print(command)
    os.system(command)
    directory = "enhancer_predictions.%d" % number
    input_filename = "%s/enhancers.bed" % directory
    output_filename = "enhancer_predictions_randomized/enhancers.%s.%d.bed" % (dataset, number)
    print("Renaming output to %s" % output_filename)
    os.rename(input_filename, output_filename)
    print("Removing %s" % directory)
    shutil.rmtree(directory)
    print("Removing pathlist")
    os.remove("pathlist")
